//This file is part of The BBCut Library. Copyright (C) 2001  Nick M.Collins distributed under the terms of the GNU General Public License full notice in file BBCutLibrary.help

//N.M.Collins 24/10/01 

//quick version - no normalisation step, but then avoids any controversy
//over what the normalisation step should be
//no worry over how many non zero weights

StatBalStream : Stream
{

	var <>states,<>weights,<>heterogeneity,<>length,<counter,<stats,<>accent=1;

*new { arg states, weights, heterogeneity=0.0, length=inf;	

		^super.new.states_(states).weights_(weights).heterogeneity_(heterogeneity).length_(length).reset
	}
	
	next {	//v is expected increment
			var choice,best,temp,actual;
			
			^if (counter >= length, {
				nil
			},{
				
				//stat balance procedure, no normalisation
				
				//create expected increments, choosing least as candidate
				choice=states.size.rand;
				
				best=inf;
				
				weights.do(
				{
				arg val,i;
				
				temp= stats.at(i)+((accent+(heterogeneity*(1.0.rand)))/val);
				
				if(temp<best,{best=temp;choice=i;});
			
				}
				);
				
				//actual increment
				actual= accent/weights.at(choice);
					
				//update statistics, no normalisation
				weights.do(
				{
				arg val,i;
				
				if(i==choice,
				{
				stats.put(i,stats.at(i)+actual)
				},
				{
				stats.put(i,stats.at(i))
				}
				);
				
				}
				);
					
		counter = counter + 1;	
		states.at(choice)
				
		})	
}
	
reset {
counter = 0;		
stats= Array.fill(states.size,{0.0}); 
}

}


